/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.core;

import com.pvsstudio.core.AstVisitor;
import com.pvsstudio.core.BasicAnnotation;
import com.pvsstudio.core.BinaryOperator;
import com.pvsstudio.core.ConditionTargets;
import com.pvsstudio.core.Context;
import com.pvsstudio.core.CoreJNI;
import com.pvsstudio.core.ExpressionSide;
import com.pvsstudio.core.IndexArray;
import com.pvsstudio.core.Int128;
import com.pvsstudio.core.LogicOperator;
import com.pvsstudio.core.Loop;
import com.pvsstudio.core.Pool;
import com.pvsstudio.core.Switch;
import com.pvsstudio.core.TryStatement;
import com.pvsstudio.core.Type;
import com.pvsstudio.core.TypeInformation;
import com.pvsstudio.core.UnaryOperator;
import com.pvsstudio.core.Value;
import com.pvsstudio.core.Variable;
import com.pvsstudio.core.VariableState;
import com.pvsstudio.core.VirtualValue;

public class Analyzer {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Analyzer(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(Analyzer obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CoreJNI.delete_Analyzer(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public Pool getPool() {
        long cPtr = CoreJNI.Analyzer_getPool(this.swigCPtr, this);
        return new Pool(cPtr);
    }

    public boolean isUnreachable() {
        return CoreJNI.Analyzer_isUnreachable(this.swigCPtr, this);
    }

    public boolean isInFunction() {
        return CoreJNI.Analyzer_isInFunction(this.swigCPtr, this);
    }

    public boolean isInGlobalNamespace() {
        return CoreJNI.Analyzer_isInGlobalNamespace(this.swigCPtr, this);
    }

    public boolean isInFirstIteration() {
        return CoreJNI.Analyzer_isInFirstIteration(this.swigCPtr, this);
    }

    public boolean isInCondition() {
        return CoreJNI.Analyzer_isInCondition(this.swigCPtr, this);
    }

    public Switch currentSwitch() {
        return new Switch(CoreJNI.Analyzer_currentSwitch(this.swigCPtr, this), false);
    }

    public Loop currentLoop() {
        return new Loop(CoreJNI.Analyzer_currentLoop(this.swigCPtr, this), false);
    }

    public TryStatement currentTry() {
        return new TryStatement(CoreJNI.Analyzer_currentTry(this.swigCPtr, this), false);
    }

    public Value visitIntegerLiteral(long value, Type type) {
        long cPtr = CoreJNI.Analyzer_visitIntegerLiteral__SWIG_0(this.swigCPtr, this, value, type.swigValue());
        return cPtr == 0L ? Value.EMPTY : new Value(cPtr);
    }

    public Value visitIntegerLiteral(Int128 value, Type type) {
        long cPtr = CoreJNI.Analyzer_visitIntegerLiteral__SWIG_1(this.swigCPtr, this, Int128.getCPtr(value), value, type.swigValue());
        return cPtr == 0L ? Value.EMPTY : new Value(cPtr);
    }

    public Value visitBooleanLiteral(boolean value) {
        long cPtr = CoreJNI.Analyzer_visitBooleanLiteral(this.swigCPtr, this, value);
        return cPtr == 0L ? Value.EMPTY : new Value(cPtr);
    }

    public Value visitStringLiteral(String s, long charSize) {
        long cPtr = CoreJNI.Analyzer_visitStringLiteral(this.swigCPtr, this, s, charSize);
        return cPtr == 0L ? Value.EMPTY : new Value(cPtr);
    }

    public Value visitNull() {
        long cPtr = CoreJNI.Analyzer_visitNull(this.swigCPtr, this);
        return cPtr == 0L ? Value.EMPTY : new Value(cPtr);
    }

    public Value visitNotNull() {
        long cPtr = CoreJNI.Analyzer_visitNotNull(this.swigCPtr, this);
        return cPtr == 0L ? Value.EMPTY : new Value(cPtr);
    }

    public Value visitNullable() {
        long cPtr = CoreJNI.Analyzer_visitNullable(this.swigCPtr, this);
        return cPtr == 0L ? Value.EMPTY : new Value(cPtr);
    }

    public boolean visitLabel(String label) {
        return CoreJNI.Analyzer_visitLabel(this.swigCPtr, this, label);
    }

    public void deleteValue(Variable var, boolean deleteOnlyState) {
        CoreJNI.Analyzer_deleteValue__SWIG_0(this.swigCPtr, this, Variable.getCPtr(var), var, deleteOnlyState);
    }

    public void deleteValue(Variable var) {
        CoreJNI.Analyzer_deleteValue__SWIG_1(this.swigCPtr, this, Variable.getCPtr(var), var);
    }

    public void setValue(Variable var, VariableState state) {
        CoreJNI.Analyzer_setValue(this.swigCPtr, this, Variable.getCPtr(var), var, VariableState.getCPtr(state), state);
    }

    public void visitUnreachable() {
        CoreJNI.Analyzer_visitUnreachable(this.swigCPtr, this);
    }

    public void visitReachable() {
        CoreJNI.Analyzer_visitReachable(this.swigCPtr, this);
    }

    public void visitCase(VirtualValue caseValue, TypeInformation caseType) {
        CoreJNI.Analyzer_visitCase(this.swigCPtr, this, VirtualValue.getCPtr(caseValue), TypeInformation.getCPtr(caseType), caseType);
    }

    public void clearCaseValues() {
        CoreJNI.Analyzer_clearCaseValues(this.swigCPtr, this);
    }

    public boolean visitCaseValue(VirtualValue value, TypeInformation caseType) {
        return CoreJNI.Analyzer_visitCaseValue(this.swigCPtr, this, VirtualValue.getCPtr(value), TypeInformation.getCPtr(caseType), caseType);
    }

    public void visitDefault() {
        CoreJNI.Analyzer_visitDefault(this.swigCPtr, this);
    }

    public void visitBreak() {
        CoreJNI.Analyzer_visitBreak(this.swigCPtr, this);
    }

    public void visitContinue() {
        CoreJNI.Analyzer_visitContinue(this.swigCPtr, this);
    }

    public void visitAssert() {
        CoreJNI.Analyzer_visitAssert(this.swigCPtr, this);
    }

    public void visitReturn(Value value) {
        CoreJNI.Analyzer_visitReturn(this.swigCPtr, this, Value.getCPtr(value));
    }

    public VirtualValue getReturnValue() {
        long cPtr = CoreJNI.Analyzer_getReturnValue(this.swigCPtr, this);
        return cPtr == 0L ? VirtualValue.EMPTY : new VirtualValue(cPtr);
    }

    public boolean returnsSameValue() {
        return CoreJNI.Analyzer_returnsSameValue(this.swigCPtr, this);
    }

    public Value visitFunctionCall(Context context, BasicAnnotation annotation) {
        long cPtr = CoreJNI.Analyzer_visitFunctionCall(this.swigCPtr, this, Context.getCPtr(context), context, BasicAnnotation.getCPtr(annotation), annotation);
        return cPtr == 0L ? Value.EMPTY : new Value(cPtr);
    }

    public void visitCondition(boolean isLogicOperator, long tree, AstVisitor cond, AstVisitor ifTrue, AstVisitor ifFalse, boolean removePotentiallyUninitialized) {
        CoreJNI.Analyzer_visitCondition__SWIG_0(this.swigCPtr, this, isLogicOperator, tree, AstVisitor.getCPtr(cond), cond, AstVisitor.getCPtr(ifTrue), ifTrue, AstVisitor.getCPtr(ifFalse), ifFalse, removePotentiallyUninitialized);
    }

    public void visitCondition(boolean isLogicOperator, long tree, AstVisitor cond, AstVisitor ifTrue, AstVisitor ifFalse) {
        CoreJNI.Analyzer_visitCondition__SWIG_1(this.swigCPtr, this, isLogicOperator, tree, AstVisitor.getCPtr(cond), cond, AstVisitor.getCPtr(ifTrue), ifTrue, AstVisitor.getCPtr(ifFalse), ifFalse);
    }

    public void visitShortCircuit(boolean isLeftLogicOperator, boolean isRightLogicOperator, long lhsTree, LogicOperator arg3, AstVisitor lhs, AstVisitor rhs) {
        CoreJNI.Analyzer_visitShortCircuit(this.swigCPtr, this, isLeftLogicOperator, isRightLogicOperator, lhsTree, arg3.swigValue(), AstVisitor.getCPtr(lhs), lhs, AstVisitor.getCPtr(rhs), rhs);
    }

    public void visitCondition(Value value) {
        CoreJNI.Analyzer_visitCondition__SWIG_2(this.swigCPtr, this, Value.getCPtr(value));
    }

    public void visitLoopCondition(boolean isLogicOperator, AstVisitor cond) {
        CoreJNI.Analyzer_visitLoopCondition(this.swigCPtr, this, isLogicOperator, AstVisitor.getCPtr(cond), cond);
    }

    public void visitEmptyLoopCondition() {
        CoreJNI.Analyzer_visitEmptyLoopCondition(this.swigCPtr, this);
    }

    public void visitTrueLoopCondition() {
        CoreJNI.Analyzer_visitTrueLoopCondition(this.swigCPtr, this);
    }

    public void visitLoopPostCondition(boolean isLogicOperator, AstVisitor cond, boolean isAlwaysFalse) {
        CoreJNI.Analyzer_visitLoopPostCondition(this.swigCPtr, this, isLogicOperator, AstVisitor.getCPtr(cond), cond, isAlwaysFalse);
    }

    public void visitBinaryCondition(ConditionTargets targets, BinaryOperator op, ExpressionSide side, VirtualValue other, TypeInformation otherType) {
        CoreJNI.Analyzer_visitBinaryCondition(this.swigCPtr, this, ConditionTargets.getCPtr(targets), targets, op.swigValue(), side.swigValue(), VirtualValue.getCPtr(other), TypeInformation.getCPtr(otherType), otherType);
    }

    public void visitUnaryCondition(ConditionTargets targets, UnaryOperator op) {
        CoreJNI.Analyzer_visitUnaryCondition(this.swigCPtr, this, ConditionTargets.getCPtr(targets), targets, op.swigValue());
    }

    public void visitBooleanCondition(ConditionTargets targets) {
        CoreJNI.Analyzer_visitBooleanCondition(this.swigCPtr, this, ConditionTargets.getCPtr(targets), targets);
    }

    public long[] getDeadStores() {
        return CoreJNI.Analyzer_getDeadStores(this.swigCPtr, this);
    }

    public void visitParameter(Variable parameter) {
        CoreJNI.Analyzer_visitParameter(this.swigCPtr, this, Variable.getCPtr(parameter), parameter);
    }

    public void visitDereference(Value value, long path, long depth, IndexArray additionalPath) {
        CoreJNI.Analyzer_visitDereference__SWIG_0(this.swigCPtr, this, Value.getCPtr(value), path, depth, IndexArray.getCPtr(additionalPath), additionalPath);
    }

    public void visitDereference(Value value, long path, long depth) {
        CoreJNI.Analyzer_visitDereference__SWIG_1(this.swigCPtr, this, Value.getCPtr(value), path, depth);
    }

    public void visitDereference(Value value, long path) {
        CoreJNI.Analyzer_visitDereference__SWIG_2(this.swigCPtr, this, Value.getCPtr(value), path);
    }

    public void visitDereference(Value value) {
        CoreJNI.Analyzer_visitDereference__SWIG_3(this.swigCPtr, this, Value.getCPtr(value));
    }

    public void visitDereference(Variable variable, long path, long depth, IndexArray additionalPath) {
        CoreJNI.Analyzer_visitDereference__SWIG_4(this.swigCPtr, this, Variable.getCPtr(variable), variable, path, depth, IndexArray.getCPtr(additionalPath), additionalPath);
    }

    public void visitDereference(Variable variable, long path, long depth) {
        CoreJNI.Analyzer_visitDereference__SWIG_5(this.swigCPtr, this, Variable.getCPtr(variable), variable, path, depth);
    }

    public void visitDereference(Variable variable, long path) {
        CoreJNI.Analyzer_visitDereference__SWIG_6(this.swigCPtr, this, Variable.getCPtr(variable), variable, path);
    }

    public void visitDereference(Variable variable) {
        CoreJNI.Analyzer_visitDereference__SWIG_7(this.swigCPtr, this, Variable.getCPtr(variable), variable);
    }

    public void visitImpure() {
        CoreJNI.Analyzer_visitImpure(this.swigCPtr, this);
    }

    public void visitNoReturn() {
        CoreJNI.Analyzer_visitNoReturn(this.swigCPtr, this);
    }

    public void visitRead(Value value) {
        CoreJNI.Analyzer_visitRead__SWIG_0(this.swigCPtr, this, Value.getCPtr(value));
    }

    public void visitRead(Variable variable) {
        CoreJNI.Analyzer_visitRead__SWIG_1(this.swigCPtr, this, Variable.getCPtr(variable), variable);
    }

    public void clear() {
        CoreJNI.Analyzer_clear(this.swigCPtr, this);
    }

    public void release() {
        CoreJNI.Analyzer_release(this.swigCPtr, this);
    }
}

