/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import com.pvsstudio.PvsStudioDownloader;
import com.pvsstudio.PvsStudioException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import org.jetbrains.annotations.NotNull;

public final class Version {
    public static final String CURRENT_VERSION = "7.39.100930";
    public static final String DEVELOPMENT_VERSION = "0.0.0";
    private static String actualVersion = "7.39.100930";
    private static String latestVersion = "";
    private static boolean beta = false;

    private Version() {
    }

    public static String getActualVersion() {
        return actualVersion;
    }

    public static String getLatestVersion() {
        if (latestVersion.isEmpty()) {
            PvsStudioDownloader.tryExecuteAction(Version::initLatestVersion);
        }
        return latestVersion;
    }

    public static boolean isDevelopment() {
        return CURRENT_VERSION.equals(DEVELOPMENT_VERSION);
    }

    public static boolean isBeta() {
        return beta;
    }

    public static void setBeta(boolean isBeta) {
        beta = isBeta;
    }

    public static void setActualVersion(String version) {
        actualVersion = version;
    }

    private static boolean initLatestVersion(@NotNull Proxy proxy) {
        boolean bl;
        URLConnection connection = new URL(String.format("%s/latest.version", "http://files.pvs-studio.com/java")).openConnection(proxy);
        connection.setReadTimeout(1500);
        connection.setConnectTimeout(1500);
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        try {
            String firstLine = in.readLine();
            latestVersion = firstLine != null ? firstLine.trim() : "";
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new PvsStudioException(e.getMessage());
            }
        }
        in.close();
        return bl;
    }
}

