/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonLocation;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.multibindings.ProvidesIntoSet;
import com.google.inject.name.Named;
import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.annotation.AnnotationService;
import com.pvsstudio.annotation.processor.ElementAnnotationProcessor;
import com.pvsstudio.annotation.user.UserConfigurationLoader;
import com.pvsstudio.annotation.user.UserConfigurationMapper;
import com.pvsstudio.annotation.user.UserConfigurationModule;
import com.pvsstudio.annotation.user.UserConfigurationValidator;
import com.pvsstudio.annotation.user.dto.Locatable;
import com.pvsstudio.annotation.user.dto.UserAnnotationConfiguration;
import com.pvsstudio.annotation.user.dto.constraint.CustomViolationMessage;
import com.pvsstudio.warnings.Warning;
import com.pvsstudio.warnings.WarningLevel;
import com.pvsstudio.warnings.WarningPosition;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.Path;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.validator.internal.engine.path.NodeImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.processing.AbstractProcessor;
import spoon.reflect.declaration.CtElement;

public class UserAnnotationProcessingModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(UserAnnotationProcessingModule.class);

    protected void configure() {
        this.install((Module)new UserConfigurationModule());
    }

    @ProvidesIntoSet
    public AbstractProcessor<? extends CtElement> provideUserAnnotations(AnalyzerConfig config, @Named(value="warnings") Set<Warning> warnings, AnnotationService service, UserConfigurationLoader loader, UserConfigurationValidator validator, UserConfigurationMapper mapper) {
        ElementAnnotationProcessor elementAnnotationProcessor;
        block16: {
            Path dotPvs = Path.of(config.projectPath, new String[0]).resolve(".PVS-Studio");
            if (!Files.exists(dotPvs, new LinkOption[0])) {
                return new ElementAnnotationProcessor(service, List.of());
            }
            Stream<Path> walk = Files.walk(dotPvs, new FileVisitOption[0]);
            try {
                List annotationFiles = walk.filter(Predicate.not(x$0 -> Files.isDirectory(x$0, new LinkOption[0]))).map(Path::toString).filter(path -> path.endsWith(".annotations.json")).map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toList());
                annotationFiles.addAll(config.annotationFiles.stream().map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toList()));
                ArrayList annotations = new ArrayList();
                for (Path annotationsFile : annotationFiles) {
                    String message;
                    if (!Files.exists(annotationsFile, new LinkOption[0])) {
                        String message2 = String.format("Invalid path to the file with user annotations: '%s'", annotationsFile);
                        warnings.add(this.deserializationWarning(message2));
                        continue;
                    }
                    try {
                        log.debug("Processing annotation file {}", (Object)annotationsFile);
                        UserAnnotationConfiguration configuration = loader.load(annotationsFile);
                        Set violations = validator.validate(configuration);
                        if (!violations.isEmpty()) {
                            for (ConstraintViolation violation : violations) {
                                String message3 = this.getMessage((ConstraintViolation<UserAnnotationConfiguration>)violation);
                                JsonLocation position = this.getJsonLocation((ConstraintViolation<UserAnnotationConfiguration>)violation);
                                WarningPosition warningPosition = position != null ? new WarningPosition(annotationsFile.toAbsolutePath().toString(), position.getLineNr(), position.getLineNr(), position.getColumnNr(), position.getColumnNr(), null) : WarningPosition.INVALID_POSITION;
                                warnings.add(new Warning("V019", message3, WarningLevel.LEVEL_0, warningPosition));
                            }
                        }
                        log.debug("Processed {} annotations", (Object)configuration.getAnnotations().size());
                        annotations.addAll(mapper.map(configuration));
                    }
                    catch (JacksonException e) {
                        message = String.format("JSON deserialization error. Error message: '%s'. Annotation file: '%s'. Location: '%s'", e.getOriginalMessage(), annotationsFile.getFileName(), e.getLocation());
                        warnings.add(this.deserializationWarning(message));
                    }
                    catch (IOException e) {
                        message = String.format("An error occurred while processing the path to the user annotations. Path: '%s'. Error message: '%s'", annotationsFile, e.getMessage());
                        warnings.add(this.deserializationWarning(message));
                    }
                }
                elementAnnotationProcessor = new ElementAnnotationProcessor(service, annotations);
                if (walk == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            walk.close();
        }
        return elementAnnotationProcessor;
    }

    @NotNull
    private String getMessage(ConstraintViolation<UserAnnotationConfiguration> violation) {
        String message = violation.getConstraintDescriptor().getGroups().contains(CustomViolationMessage.class) ? String.format(violation.getMessage(), violation.getInvalidValue()) : String.format("%s. Invalid value: '%s'.", violation.getMessage(), violation.getInvalidValue());
        return message;
    }

    @Nullable
    private JsonLocation getJsonLocation(ConstraintViolation<UserAnnotationConfiguration> violation) {
        JsonLocation position = null;
        for (Path.Node node : violation.getPropertyPath()) {
            Object object;
            if (!(node instanceof NodeImpl) || !((object = ((NodeImpl)node).getValue()) instanceof Locatable)) continue;
            Locatable locatable = (Locatable)object;
            position = locatable.jsonLocation();
        }
        return position;
    }

    private Warning deserializationWarning(String message) {
        return new Warning("V019", message, WarningLevel.LEVEL_0);
    }
}

