/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.JsonProject;
import com.pvsstudio.License;
import com.pvsstudio.PvsStudioCoreStartupException;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.Utils;
import com.pvsstudio.config.GlobalConfigService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;

public class PvsStudioInvoker {
    public static final String CANCEL_UID = "63a517f9";
    private Consumer<String> outputListener = null;
    private Process process = null;
    private boolean processIsEnded = false;
    private boolean unsupportedClassVersion = false;
    public static final String ADD_OPENS_JDK_FLAG = "--add-opens";
    public static final String NEED_FOR_JAVA_CORE_ADD_OPENS_MODULE_JDK_FLAG_ARGUMENT = "java.base/jdk.internal.loader=ALL-UNNAMED";
    public static final Pattern PROGRESS_PATTERN = Pattern.compile("\\[\\s*(\\d+)%]\\s* (.+)");

    private PvsStudioInvoker() {
    }

    public boolean processIsAlive() {
        return this.process != null && this.process.isAlive() || !this.processIsEnded;
    }

    public void sendCancelToProcess() {
        if (this.process != null) {
            try (BufferedWriter out = new BufferedWriter(new PrintWriter(this.process.getOutputStream()));){
                out.write(CANCEL_UID);
                out.newLine();
                out.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public PvsStudioInvoker onOutput(@NotNull Consumer<String> listener) {
        this.outputListener = listener;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int run(@Nullable JsonProject project, @NotNull AnalyzerConfig config) {
        AnalyzerConfig normalizedConfig;
        try {
            normalizedConfig = config.normalizeAndReadLicenseFile();
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            throw new PvsStudioException("An error occurred while reading the license file.", ex);
        }
        try {
            GlobalConfigService globalConfigService = new GlobalConfigService(AnalyzerConfig.PVS_JAVA_GLOBAL_CONFIG_FILE_STANDARD_PATH);
            boolean isDirty = globalConfigService.syncWithLocal(normalizedConfig);
            if (isDirty) {
                globalConfigService.save();
            }
        }
        catch (JsonParseException | IOException ex) {
            throw new PvsStudioException("An error occurred while saving or loading file: " + AnalyzerConfig.PVS_JAVA_GLOBAL_CONFIG_FILE_STANDARD_PATH, ex);
        }
        normalizedConfig.createProjectDirectory();
        String jsonPath = Utils.absolutePath(normalizedConfig.projectPath, JsonProject.FILENAME);
        String pathForTempArgsConfigJsonFile = normalizedConfig.getPathForTempArgsConfigJsonFile();
        try {
            int rc;
            if (project != JsonProject.EMPTY) {
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(Paths.get(jsonPath, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8));){
                    new GsonBuilder().setLenient().create().toJson((Object)project, (Appendable)writer);
                }
                catch (IOException ex) {
                    throw new PvsStudioException("Unable to save json project structure file", ex);
                }
            }
            if (normalizedConfig.launchMode != AnalyzerConfig.LaunchMode.CORE) {
                normalizedConfig.projectType = "json";
            }
            this.process = new ProcessBuilder(normalizedConfig.getCommandLineForRunJavaCoreWithTempCfgFileCreation()).redirectErrorStream(true).start();
            this.readProcess();
            try {
                rc = this.process.waitFor();
            }
            catch (InterruptedException ex) {
                rc = 0;
                Thread.currentThread().interrupt();
            }
            this.process = null;
            this.processIsEnded = true;
            if (rc == 0) return rc;
            switch (rc) {
                case 50: 
                case 51: 
                case 52: {
                    return rc;
                }
                case 53: {
                    throw new PvsStudioException("Analyzer warnings are detected.");
                }
                case 54: {
                    throw new PvsStudioException("Enterprise License Restrictions.");
                }
                default: {
                    if (!this.unsupportedClassVersion) throw new PvsStudioCoreStartupException(String.format("Failed to run PVS-Studio Java analyzer core (return code %d). Please contact us at 'https://pvs-studio.com/en/about-feedback/'", rc));
                    throw new PvsStudioCoreStartupException(String.format("Failed to run PVS-Studio Java analyzer core. Make sure the correct 64-bit Java %d or higher executable is used, or specify it manually.", 11));
                }
            }
        }
        catch (IOException ex) {
            throw new PvsStudioException("Unexpected error.", ex);
        }
        finally {
            if (!normalizedConfig.verbose.booleanValue()) {
                if (!new File(jsonPath).delete()) {
                    System.out.println("Failed to delete file: " + jsonPath);
                }
                if (!new File(pathForTempArgsConfigJsonFile).delete()) {
                    System.out.println("Failed to delete file: " + pathForTempArgsConfigJsonFile);
                }
            }
            if (this.process != null) {
                try {
                    this.process.destroy();
                    this.process.waitFor();
                }
                catch (Exception exception) {}
            }
            this.processIsEnded = true;
        }
    }

    public static PvsStudioInvoker runAnalyzerCoreProcess(@NotNull Consumer<String> onOutput) {
        return new PvsStudioInvoker().onOutput(onOutput);
    }

    public static int runAnalyzerCoreProcess(@NotNull Consumer<String> onOutput, @NotNull AnalyzerConfig config, @NotNull JsonProject jsonProject) {
        return new PvsStudioInvoker().onOutput(onOutput).run(jsonProject, config);
    }

    public static int runAnalyzerCoreProcessWithEmptyJsonProject(@NotNull AnalyzerConfig config) {
        return PvsStudioInvoker.runAnalyzerCoreProcessWithEmptyJsonProject(l -> {}, config);
    }

    public static int runAnalyzerCoreProcessWithEmptyJsonProject(@NotNull Consumer<String> onOutput, @NotNull AnalyzerConfig config) {
        return PvsStudioInvoker.runAnalyzerCoreProcess(onOutput).run(JsonProject.EMPTY, config);
    }

    @NotNull
    public static CheckLicenseInfoFromSeparateProcess checkLicenseFromPvsStudioJar(@NotNull AnalyzerConfig credentials) {
        AnalyzerConfig configForCheckLicense = credentials.copy();
        configForCheckLicense.verbose = true;
        configForCheckLicense.checkLicense = true;
        configForCheckLicense.traceLogFileName = "pvs-license.log";
        configForCheckLicense.traceSpoonLogFileName = "spoon-license.log";
        StringBuilder output = new StringBuilder();
        int exitCode = PvsStudioInvoker.runAnalyzerCoreProcessWithEmptyJsonProject(l -> output.append((String)l).append(System.lineSeparator()), configForCheckLicense);
        return CheckLicenseInfoFromSeparateProcess.getCheckLicenseInfo(output, exitCode);
    }

    protected void readProcess() throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(this.process.getInputStream()));){
            String line;
            while ((line = in.readLine()) != null) {
                if (line.contains("no main manifest attribute, in")) {
                    throw new PvsStudioCoreStartupException("Failed to run PVS-Studio Java analyzer core. Assembly is incomplete.");
                }
                if (line.contains("UnsupportedClassVersionError")) {
                    this.unsupportedClassVersion = true;
                }
                if (this.outputListener == null) continue;
                this.outputListener.accept(line);
            }
        }
    }

    public static class CheckLicenseInfoFromSeparateProcess {
        public static final CheckLicenseInfoFromSeparateProcess EMPTY = new CheckLicenseInfoFromSeparateProcess(false, false, false, 0L, "", "", new String[0], -1);
        public final boolean isTimedOut;
        public final boolean isEnterprise;
        public final long daysLeft;
        public final int exitCode;
        public final boolean valid;
        public final String status;
        @NotNull
        public final String[] processStdoutLines;
        public final String licenseType;

        public static CheckLicenseInfoFromSeparateProcess getCheckLicenseInfo(@NotNull StringBuilder processCheckLicenseStdout, int processCheckLicenseExitCode) {
            License licenseResult = null;
            String[] outputLines = processCheckLicenseStdout.toString().split(System.lineSeparator());
            if (outputLines.length != 0) {
                for (int i = outputLines.length - 1; i >= 0; --i) {
                    if (!outputLines[i].startsWith("{") || !outputLines[i].endsWith("}")) continue;
                    try {
                        licenseResult = (License)new GsonBuilder().setLenient().create().fromJson(outputLines[i], License.class);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (licenseResult == null) {
                licenseResult = new License();
            }
            return new CheckLicenseInfoFromSeparateProcess(licenseResult.isTimedOut(), licenseResult.isEnterprise(), licenseResult.valid, licenseResult.getDaysLeft(), licenseResult.status, licenseResult.type, outputLines, processCheckLicenseExitCode);
        }

        private CheckLicenseInfoFromSeparateProcess(boolean isTimedOut, boolean isEnterprise, boolean valid, long daysLeft, @NotNull String status, @NotNull String licenseType, @NotNull String[] processStdoutLines, int exitCode) {
            this.isTimedOut = isTimedOut;
            this.isEnterprise = isEnterprise;
            this.valid = valid;
            this.daysLeft = daysLeft;
            this.status = status;
            this.licenseType = licenseType;
            this.processStdoutLines = processStdoutLines;
            this.exitCode = exitCode;
        }
    }
}

