/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.AnalyzerModule;
import com.pvsstudio.JsonProject;
import com.pvsstudio.License;
import com.pvsstudio.LicenseFileInfo;
import com.pvsstudio.LicenseRegistration;
import com.pvsstudio.PvsOSUtils;
import com.pvsstudio.PvsStudioConfigException;
import com.pvsstudio.PvsStudioEmptyLicenseException;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.PvsStudioHelpException;
import com.pvsstudio.PvsStudioInvoker;
import com.pvsstudio.PvsStudioLicenseException;
import com.pvsstudio.Utils;
import com.pvsstudio.Version;
import com.pvsstudio.config.ConfigMerger;
import com.pvsstudio.config.GlobalConfigService;
import com.pvsstudio.core.LicenseUtils;
import com.pvsstudio.core.RegistrationInfo;
import com.pvsstudio.formats.HtmlOutput;
import com.pvsstudio.projects.BasicProjectEvaluator;
import com.pvsstudio.projects.JsonEvaluator;
import com.pvsstudio.projects.Project;
import com.pvsstudio.projects.ProjectEvaluator;
import com.pvsstudio.runner.AnalysisCancelledException;
import com.pvsstudio.runner.AnalyzerProgress;
import com.pvsstudio.runner.AnalyzerRunner;
import com.pvsstudio.runner.Benchmark;
import com.pvsstudio.runner.NativeLoader;
import com.pvsstudio.util.license.LicenseWriter;
import com.pvsstudio.warnings.JsonFormat;
import com.pvsstudio.warnings.SuppressBase;
import com.pvsstudio.warnings.Warning;
import com.pvsstudio.warnings.WarningsFormatFactory;
import com.pvsstudio.warnings.WarningsInput;
import com.pvsstudio.warnings.WarningsOutput;
import com.pvsstudio.warnings.WarningsSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;
import picocli.CommandLine;

public class Main {
    @NotNull
    private static AnalyzerConfig readConfigFromCommandLineArgument(@Nullable String configFile) throws IOException {
        AnalyzerConfig analyzerConfig;
        Gson gson = new GsonBuilder().setLenient().create();
        JsonReader fileReader = new JsonReader((Reader)new FileReader(configFile == null ? "config.json" : configFile));
        try {
            AnalyzerConfig config = (AnalyzerConfig)gson.fromJson(fileReader, AnalyzerConfig.class);
            if (config == null) {
                throw new PvsStudioException("invalid config.json");
            }
            analyzerConfig = config;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                if (configFile == null) {
                    return AnalyzerConfig.blankConfig();
                }
                throw new PvsStudioException("config.json was not found", e);
            }
        }
        fileReader.close();
        return analyzerConfig;
    }

    private static AnalyzerConfig getNormalizedConfig(String[] args) throws IOException, ParserConfigurationException, SAXException {
        AnalyzerConfig argsConfig = (AnalyzerConfig)CommandLine.populateCommand((Object)AnalyzerConfig.blankConfig(), (String[])args);
        if (argsConfig.helpRequired != null && argsConfig.helpRequired.booleanValue() || args.length == 0) {
            throw new PvsStudioHelpException();
        }
        if (Boolean.TRUE.equals(argsConfig.activateLicense)) {
            if (argsConfig.getUserName() == null || argsConfig.getLicenseKey() == null) {
                throw new PvsStudioConfigException("License activation requires credentials. Please provide them via the '--username' and '--license-key' flags.");
            }
        } else if (argsConfig.licensePath != null && (argsConfig.getUserName() != null || argsConfig.getLicenseKey() != null)) {
            throw new PvsStudioConfigException("The combination of 'license-path' and 'credentials' arguments is only allowed with the '--activate-license' flag.");
        }
        AnalyzerConfig configFromJsonFileWithArgs = Main.readConfigFromCommandLineArgument(argsConfig.configFile);
        AnalyzerConfig globalConfig = new GlobalConfigService(AnalyzerConfig.PVS_JAVA_GLOBAL_CONFIG_FILE_STANDARD_PATH).getAsAnalyzerConfig();
        AnalyzerConfig mergedConfig = AnalyzerConfig.blankConfig();
        ConfigMerger.merger(argsConfig, configFromJsonFileWithArgs, globalConfig).merge(mergedConfig);
        AnalyzerConfig mergedAndNormalizedConfig = mergedConfig.normalizeAndReadLicenseFile();
        if (mergedAndNormalizedConfig.externalsFile != null) {
            String classpath = Files.readString(Paths.get(mergedAndNormalizedConfig.externalsFile, new String[0]), Charset.defaultCharset());
            mergedAndNormalizedConfig.externals = Arrays.stream(classpath.split(File.pathSeparator)).map(String::trim).collect(Collectors.toSet());
        }
        if (mergedAndNormalizedConfig.analyzeOnlyList != null && Files.exists(Paths.get(mergedAndNormalizedConfig.analyzeOnlyList, new String[0]), new LinkOption[0])) {
            List<String> lines = Files.readAllLines(Paths.get(mergedAndNormalizedConfig.analyzeOnlyList, new String[0]), StandardCharsets.UTF_8);
            lines.stream().map(String::trim).map(line -> StringUtils.strip((String)line, (String)"\"")).map(File::new).filter(File::exists).forEach(file -> mergedAndNormalizedConfig.analyzeOnly.add(file.getAbsolutePath()));
        }
        Stream.of(Collections.singletonList(mergedAndNormalizedConfig.projectPath), mergedAndNormalizedConfig.sources, mergedAndNormalizedConfig.externals).flatMap(Collection::stream).filter(s -> s != null && !Paths.get(s, new String[0]).toFile().exists()).findFirst().ifPresent(s -> {
            throw new PvsStudioException(s + " does not exist");
        });
        mergedAndNormalizedConfig.createProjectDirectory();
        mergedAndNormalizedConfig.configureLogger();
        return mergedAndNormalizedConfig;
    }

    private static Project getProject(@NotNull AnalyzerConfig config, @NotNull AnalyzerProgress progress) {
        ProjectEvaluator projectEvaluator;
        switch (config.projectType) {
            case "sources": {
                projectEvaluator = new BasicProjectEvaluator();
                break;
            }
            case "json": {
                projectEvaluator = new JsonEvaluator();
                break;
            }
            default: {
                throw new PvsStudioConfigException("unknown project type");
            }
        }
        System.out.printf("Analyzing project at %s%n", config.projectPath);
        return projectEvaluator.evaluate(config, progress);
    }

    private static void showHelp() {
        CommandLine commandLine = new CommandLine((Object)AnalyzerConfig.blankConfig());
        commandLine.setUsageHelpLongOptionsMaxWidth(30);
        commandLine.setUsageHelpWidth(85);
        System.out.println(String.format("PVS-Studio %s%s\n", "Beta ", "7.39.100930") + "Copyright (c) 2019-2025 PVS-Studio LLC\nPVS-Studio is a static code analyzer and SAST (static application security\ntesting) tool that is available for C and C++ desktop and embedded development,\n C# and Java under Windows, Linux and macOS.");
        commandLine.usage(System.out);
        System.out.println("Quick usage examples:");
        System.out.println("java -jar pvs-studio.jar -s A.java B.java C.java -e Lib1.jar Lib2.jar -j4 -o out.txt -O text");
        System.out.println("java -jar pvs-studio.jar -s src/main/java --ext-file classpath.txt -j4 -o out.txt -O text");
        System.out.println();
        System.out.println("See https://pvs-studio.com/en/docs/manual/6703/ for more details.");
    }

    private static void tryCreateFile(String path) {
        File outputFile = new File(path);
        if (!(outputFile.exists() || outputFile.getParentFile() == null || outputFile.getParentFile().exists() || outputFile.getParentFile().mkdirs())) {
            throw new PvsStudioException(String.format("Unable to create %s", path));
        }
    }

    private static void checkVersion(@NotNull WarningsSet warnings) {
        if (Version.isDevelopment()) {
            return;
        }
        try {
            URL urlJavaReleaseVersion;
            Predicate<String> isNewer = ver -> {
                String[] split1 = ver.split("\\.");
                String[] split2 = "7.39.100930".split("\\.");
                if (split1.length >= 2 && split2.length >= 2) {
                    return split1[0].compareTo(split2[0]) > 0 || split1[0].compareTo(split2[0]) == 0 && split1[1].compareTo(split2[1]) > 0;
                }
                return false;
            };
            URL urlGlobalVersion = new URL("https://pvs-studio.com/version.xml");
            String contentFromUrl = IOUtils.toString((URL)urlGlobalVersion, (Charset)StandardCharsets.UTF_8).trim();
            String readVersion = contentFromUrl.split("<Version>")[1].split("</Version>")[0];
            if (isNewer.test(readVersion) && !(readVersion = IOUtils.toString((URL)(urlJavaReleaseVersion = new URL(String.format("%s/latest.version", "http://files.pvs-studio.com/java"))), (Charset)StandardCharsets.UTF_8).trim()).equals("7.39.100930") && isNewer.test(readVersion)) {
                warnings.add(Warning.updateMessage(readVersion));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void checkEnterpriseRestrictions(@NotNull AnalyzerConfig config, @NotNull PvsStudioInvoker.CheckLicenseInfoFromSeparateProcess checkLicenseInfo) {
        if (checkLicenseInfo.isEnterprise || config.launchMode == AnalyzerConfig.LaunchMode.IDEA || config.launchMode == AnalyzerConfig.LaunchMode.VSCODE) {
            return;
        }
        if (config.incremental.booleanValue()) {
            System.out.println("The incremental analysis mode for the command-line analyzer is available only under Enterprise license.");
            System.exit(54);
        }
        if (!config.analyzeOnly.isEmpty() || config.analyzeOnlyList != null) {
            System.out.println("Source files list analysis mode is available only under Enterprise license.");
            System.exit(54);
        }
        if (config.sonarQubeData != null) {
            System.out.println("The SonarQube integration is available for an Enterprise license only.");
            config.sonarQubeData = null;
        }
    }

    private static void checkLicenseInNewJavaAnalyzerCoreProcess(@NotNull AnalyzerConfig config, @NotNull WarningsSet warnings) {
        Utils.allCredentialsPresent(config, message -> {
            throw new PvsStudioEmptyLicenseException((String)message);
        });
        if (config.checkLicense.booleanValue()) {
            NativeLoader.loadInCheckLicenseProcess();
            RegistrationInfo registrationInfo = LicenseUtils.checkLicense(config.getUserName(), config.getLicenseKey());
            License license = new License();
            license.valid = registrationInfo.getValid();
            license.type = registrationInfo.getLicenseType();
            license.timeout = registrationInfo.getTimeout();
            if (!config.disableDiag.booleanValue()) {
                LicenseRegistration.sendLicenseRegistration(config.getUserName(), config.getLicenseKey(), license);
            }
            new Gson().toJson((Object)license, (Appendable)System.out);
            String existsLicenseFilePath = config.licensePath != null && new File(config.licensePath).exists() ? config.licensePath : AnalyzerConfig.getExistLicenseFileStandardPath();
            System.out.println();
            System.out.println("Path to file with license information:");
            System.out.println(existsLicenseFilePath);
            System.exit(0);
        } else {
            PvsStudioInvoker.CheckLicenseInfoFromSeparateProcess checkLicenseInfo = PvsStudioInvoker.checkLicenseFromPvsStudioJar(config);
            if (checkLicenseInfo.exitCode == 0) {
                if (!checkLicenseInfo.valid) {
                    throw new PvsStudioLicenseException("Invalid License");
                }
                if (checkLicenseInfo.isTimedOut) {
                    throw new PvsStudioLicenseException("Timed Out License");
                }
                Main.checkEnterpriseRestrictions(config, checkLicenseInfo);
                long daysLeft = checkLicenseInfo.daysLeft;
                if (daysLeft < 31L) {
                    warnings.add(Warning.monthExpirationMessage(daysLeft));
                }
            } else {
                for (String processStdoutLine : checkLicenseInfo.processStdoutLines) {
                    System.out.println(processStdoutLine);
                }
                System.out.println("Check license process exitCode: " + checkLicenseInfo.exitCode);
                System.exit(checkLicenseInfo.exitCode);
            }
        }
    }

    private static void deleteIfFullhtmlExist(String path) {
        if (new File(path).exists() && new File(path, "fullhtml").exists()) {
            try {
                FileUtils.deleteDirectory((File)new File(path, "fullhtml"));
            }
            catch (IOException e) {
                throw new PvsStudioException(String.format("Unable to remove old HTML report: %s.", new File(path, "fullhtml").getAbsolutePath()));
            }
        }
    }

    private static void printInfoAboutIncorrectVersionJson(int fact, int expected) {
        System.out.printf("You are trying to load a PVS-Studio log with version %s while currently supported version is %s. Please update your PVS-Studio installation.%n", fact, expected);
    }

    private static void convertReportToFullHtml(AnalyzerConfig config) {
        WarningsSet warnings;
        if (config.srcConvert != null && config.dstConvert != null) {
            Main.deleteIfFullhtmlExist(config.dstConvert);
            if (!new File(config.dstConvert).exists() && !new File(config.dstConvert).mkdirs()) {
                throw new PvsStudioException(String.format("Couldn't create directory for HTML report:  %s", config.dstConvert));
            }
            if (!new File(config.srcConvert).exists()) {
                throw new PvsStudioException(String.format("%s does not exist", config.srcConvert));
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(config.srcConvert));){
                warnings = new JsonFormat().read(reader, Main::printInfoAboutIncorrectVersionJson);
            }
            catch (IOException err) {
                throw new PvsStudioException("Couldn't read log " + config.srcConvert, err);
            }
            if (!StringUtils.isEmpty((CharSequence)config.sourceTreeRoot)) {
                warnings.makeAbsolutePaths(config.sourceTreeRoot);
            }
        } else {
            throw new PvsStudioException("Invalid arguments. Check --src-convert or --dst-convert.");
        }
        new HtmlOutput().write(config.dstConvert, warnings);
    }

    private static void convertReportToSuppress(@NotNull AnalyzerConfig config) {
        block27: {
            if (config.srcConvert != null && config.dstConvert != null) {
                WarningsSet readWarnings;
                BufferedReader reader;
                int extensionIndex = config.srcConvert.lastIndexOf(46);
                if (extensionIndex == -1 || extensionIndex == config.srcConvert.length() - 1) {
                    throw new PvsStudioException("Incorrect file extension " + config.srcConvert);
                }
                try {
                    WarningsInput format = WarningsFormatFactory.getFormatByExtension(config.srcConvert.substring(extensionIndex + 1), WarningsInput.class);
                    reader = new BufferedReader(new FileReader(config.srcConvert));
                    try {
                        readWarnings = format.read(reader, Main::printInfoAboutIncorrectVersionJson);
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    throw new PvsStudioException("Couldn't read report " + config.srcConvert, e);
                }
                SuppressBase suppressBase = new SuppressBase();
                if (new File(config.dstConvert).exists()) {
                    try {
                        reader = new JsonReader((Reader)new FileReader(config.dstConvert));
                        try {
                            suppressBase = (SuppressBase)new GsonBuilder().setLenient().create().fromJson((JsonReader)reader, SuppressBase.class);
                        }
                        finally {
                            reader.close();
                        }
                    }
                    catch (Exception e) {
                        throw new PvsStudioException("Couldn't read suppressBase " + config.dstConvert, e);
                    }
                }
                suppressBase.addAll(readWarnings);
                File parentFile = new File(config.dstConvert).getParentFile();
                if (parentFile != null && !parentFile.exists()) {
                    parentFile.mkdirs();
                }
                try (FileWriter writer = new FileWriter(config.dstConvert);){
                    new GsonBuilder().setPrettyPrinting().create().toJson((Object)suppressBase, (Appendable)writer);
                    break block27;
                }
                catch (IOException e) {
                    throw new PvsStudioException("Couldn't save suppressBase " + config.dstConvert, e);
                }
            }
            throw new PvsStudioException("Invalid arguments. Check --src-convert or --dst-convert.");
        }
    }

    public static void main(String[] args) {
        int rc;
        AnalyzerRunner runner;
        AnalyzerConfig config;
        block78: {
            Writer writer;
            AnalyzerProgress progress;
            long startTime;
            block76: {
                startTime = System.currentTimeMillis();
                config = null;
                runner = null;
                progress = AnalyzerProgress.getInstance();
                rc = 0;
                try {
                    config = Main.getNormalizedConfig(args);
                    if (config.getVersion.booleanValue()) {
                        System.out.println("7.39.100930");
                        System.exit(0);
                    }
                    Injector injector = Guice.createInjector((Module[])new Module[]{new AnalyzerModule(config)});
                    runner = (AnalyzerRunner)injector.getInstance(AnalyzerRunner.class);
                    if (config.activateLicense.booleanValue()) {
                        config.activateLicense = false;
                        PvsStudioInvoker.CheckLicenseInfoFromSeparateProcess license = PvsStudioInvoker.checkLicenseFromPvsStudioJar(config);
                        if (!license.valid) {
                            throw new PvsStudioLicenseException("Invalid License");
                        }
                        if (license.isTimedOut) {
                            throw new PvsStudioLicenseException("Timed Out License");
                        }
                        if (StringUtils.isNotEmpty((CharSequence)config.getUserName()) || StringUtils.isNotEmpty((CharSequence)config.getLicenseKey())) {
                            LicenseWriter licenseWriter = LicenseWriter.forConfig(config);
                            licenseWriter.write(config.getUserName(), config.getLicenseKey());
                        }
                        System.exit(0);
                    }
                    if (Boolean.FALSE.equals(config.checkLicense) && config.licensePath != null) {
                        if (new File(config.licensePath).exists()) {
                            LicenseFileInfo licenseFileInfo = LicenseFileInfo.readFrom(config.licensePath);
                            config.setUserName(licenseFileInfo.getUserName());
                            config.setLicenseKey(licenseFileInfo.getLicenseKey());
                        } else {
                            throw new PvsStudioLicenseException(String.format("Path to the license file (%s) was not found.", config.licensePath));
                        }
                    }
                    if (!config.isJavaCoreSubprocessWithAddOpensForNativeLibsFieldReflectiveAccess.booleanValue() && !NativeLoader.trySetAccessToFieldLoadedLibraryNames(false)) {
                        config.verbose = true;
                        config.isJavaCoreSubprocessWithAddOpensForNativeLibsFieldReflectiveAccess = true;
                        config.traceLogFileName = "pvs-subprocess.log";
                        config.traceSpoonLogFileName = "spoon-subprocess.log";
                        PvsStudioInvoker pvsStudioInvoker = PvsStudioInvoker.runAnalyzerCoreProcess(System.out::println);
                        runner.setPvsStudioInvoker(pvsStudioInvoker);
                        System.exit(pvsStudioInvoker.run(JsonProject.EMPTY, config));
                    }
                    if (config.convert != null) {
                        if (config.convert.equals("toFullhtml")) {
                            Main.convertReportToFullHtml(config);
                            System.exit(0);
                        } else if (config.convert.equals("toSuppress")) {
                            Main.convertReportToSuppress(config);
                            System.exit(0);
                        } else {
                            throw new PvsStudioException("Unknown conversion type: " + config.convert);
                        }
                    }
                    Main.checkLicenseInNewJavaAnalyzerCoreProcess(config, runner.getWarnings());
                    Main.checkVersion(runner.getWarnings());
                    Benchmark.setActive(config.benchmark);
                    long startEvaluation = System.currentTimeMillis();
                    Project project = Main.getProject(config, progress);
                    Benchmark.instance().step("Project evaluation", System.currentTimeMillis() - startEvaluation);
                    runner.run(project);
                    if (config.sonarQubeData == null) break block76;
                    if (!new File(config.sonarQubeData).isAbsolute()) {
                        config.sonarQubeData = Utils.absolutePath(config.projectPath, config.sonarQubeData);
                    }
                    Main.tryCreateFile(config.sonarQubeData);
                    writer = new BufferedWriter(new FileWriter(config.sonarQubeData));
                    try {
                        writer.write(String.format("sonar.projectBaseDir=%s%n", config.projectPath));
                        writer.write(String.format("sonar.java.binaries=.%n", new Object[0]));
                        writer.write(String.format("sonar.sources=\\%n", new Object[0]));
                        writer.write(project.getUniqueFiles().stream().map(arg -> Utils.normalizePath(arg.getAbsolutePath())).collect(Collectors.joining(String.format(",\\%n", new Object[0]))));
                    }
                    finally {
                        ((BufferedWriter)writer).close();
                    }
                }
                catch (AnalysisCancelledException e) {
                    System.out.println("Analysis was cancelled");
                }
                catch (PvsStudioHelpException e) {
                    Main.showHelp();
                    if (args.length == 0) {
                        System.exit(51);
                    } else {
                        System.exit(0);
                    }
                }
                catch (PvsStudioConfigException | CommandLine.PicocliException e) {
                    System.out.println("Error: " + e.getMessage());
                    Main.showHelp();
                    rc = 51;
                }
                catch (Throwable e) {
                    FileNotFoundException fileNotFoundException = e instanceof FileNotFoundException ? (FileNotFoundException)e : (e instanceof PvsStudioException && e.getCause() instanceof FileNotFoundException ? (FileNotFoundException)e.getCause() : null);
                    if (fileNotFoundException != null) {
                        progress.handleException(fileNotFoundException, "", false);
                    } else if (e instanceof UnsatisfiedLinkError) {
                        String message;
                        if (PvsOSUtils.isMacArm()) {
                            message = "Analysis on Apple ARM processors is not supported. Please contact us at 'https://pvs-studio.com/en/about-feedback/' if you are interested in PVS-Studio support for these platforms.";
                        } else if (PvsOSUtils.isWindowsArm()) {
                            message = "The PVS-Studio Java analyzer core does not support the ARM JDK on Windows. Please use the x64 JDK to run the Java analyzer core. Please contact us at 'https://pvs-studio.com/en/about-feedback/' if you are interested in PVS-Studio support for ARM JDK on Windows.";
                        } else {
                            message = "Try installing the missing packages (library names from the UnsatisfiedLinkError message) on your system.";
                            progress.handleException(e, "", false);
                        }
                        System.out.println(message);
                    } else {
                        progress.handleException(e);
                    }
                    if (runner != null) {
                        runner.getWarnings().add(new Warning(e));
                    }
                    rc = e instanceof PvsStudioLicenseException ? 52 : 50;
                }
            }
            try {
                WarningsOutput output;
                if (config != null) {
                    long startOutputting = System.currentTimeMillis();
                    output = WarningsFormatFactory.getFormatByName(Objects.requireNonNull(config.outputType), WarningsOutput.class);
                    if (output instanceof HtmlOutput) {
                        Main.deleteIfFullhtmlExist(config.outputFile != null ? config.outputFile : config.projectPath);
                        if (config.outputFile == null) {
                            config.outputFile = config.projectPath;
                        }
                        if (!new File(config.outputFile).exists() && !new File(config.outputFile).mkdirs()) {
                            throw new PvsStudioException(String.format("Couldn't create directory for HTML report:  %s", config.outputFile));
                        }
                        if (!StringUtils.isEmpty((CharSequence)config.sourceTreeRoot) && runner != null) {
                            runner.getWarnings().makeAbsolutePaths(config.sourceTreeRoot);
                        }
                        ((HtmlOutput)output).write(config.outputFile, runner == null ? WarningsSet.createNew() : runner.getWarnings());
                    } else {
                        if (config.outputFile == null) {
                            config.outputFile = Utils.absolutePath(config.projectPath, "PVS-Studio." + output.extensions()[0]);
                        }
                        Main.tryCreateFile(config.outputFile);
                        writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(config.outputFile), StandardCharsets.UTF_8));
                        try {
                            Object projectPath = config.projectPath;
                            if (!StringUtils.isEmpty((CharSequence)config.sourceTreeRoot) && ((String)projectPath).startsWith("|?|")) {
                                projectPath = config.sourceTreeRoot + ((String)projectPath).substring("|?|".length());
                            }
                            output.write((String)projectPath, runner == null ? WarningsSet.createNew() : runner.getWarnings(), (BufferedWriter)writer);
                        }
                        finally {
                            ((BufferedWriter)writer).close();
                        }
                    }
                    Benchmark.instance().step("Output", System.currentTimeMillis() - startOutputting);
                } else {
                    output = null;
                }
                System.out.printf("Analysis finished in %s.%n", DurationFormatUtils.formatDuration((long)(System.currentTimeMillis() - startTime), (String)"HH:mm:ss.S"));
                if (config != null && config.outputFile != null) {
                    if (output instanceof HtmlOutput && new File(config.outputFile, "fullhtml").exists()) {
                        config.outputFile = Utils.absolutePath(config.outputFile, "fullhtml");
                    }
                    if (rc == 0) {
                        System.out.println("The results are saved to " + config.outputFile + ".");
                    } else {
                        System.out.println("The results and errors are saved to " + config.outputFile + ".");
                    }
                }
                if (!Benchmark.isActive()) break block78;
                Benchmark benchmark = Benchmark.collect();
                benchmark.dumpToStdout();
                if (config == null) break block78;
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                if (config.benchmarkPath != null) {
                    benchmark.sort();
                    Main.tryCreateFile(config.benchmarkPath);
                    writer = new FileWriter(config.benchmarkPath);
                    try {
                        gson.toJson((Object)benchmark, (Appendable)writer);
                    }
                    finally {
                        writer.close();
                    }
                }
                if (config.mergeBenchmarkPath == null) break block78;
                Benchmark merged = new Benchmark();
                if (new File(config.mergeBenchmarkPath).exists()) {
                    try (FileReader reader = new FileReader(config.mergeBenchmarkPath);){
                        merged = (Benchmark)gson.fromJson((Reader)reader, Benchmark.class);
                    }
                }
                merged.merge(benchmark);
                merged.sort();
                Main.tryCreateFile(config.mergeBenchmarkPath);
                try (FileWriter writer2 = new FileWriter(config.mergeBenchmarkPath);){
                    gson.toJson((Object)merged, (Appendable)writer2);
                }
            }
            catch (IOException e) {
                progress.handleException(e);
                if (runner != null) {
                    runner.getWarnings().add(new Warning(e));
                }
                rc = 50;
            }
            catch (Throwable e) {
                progress.handleException(e);
                throw e;
            }
        }
        if (rc == 0 && config != null && config.failOnWarnings.booleanValue() && runner != null && !runner.getWarnings().isEmpty()) {
            rc = 53;
        }
        System.exit(rc);
    }
}

