/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

public class License {
    private static final String FREE_USER_NAME = "PVS-Studio Free";
    private static final String FREE_SERIAL_NUMBER = "FREE-FREE-FREE-FREE";
    public long timeout = 0L;
    public String type = "";
    public String status = "";
    public boolean valid = false;

    public String getStatusText() {
        switch (this.getStatus().ordinal()) {
            case 2: {
                return "Expired License";
            }
            case 0: {
                return "Invalid License";
            }
            case 1: {
                return "Trial License";
            }
            case 3: {
                return "Valid License";
            }
        }
        return "";
    }

    public Status getStatus() {
        switch (this.status.toLowerCase()) {
            case "trial": {
                return Status.Trial;
            }
            case "timeout": {
                return Status.Timeout;
            }
            case "valid": {
                return Status.Valid;
            }
        }
        return Status.Invalid;
    }

    public boolean isTimedOut() {
        return this.timeout < System.currentTimeMillis() / 1000L;
    }

    public long getDaysLeft() {
        return (this.timeout - System.currentTimeMillis() / 1000L) / 86400L;
    }

    public boolean isEnterprise() {
        return this.type.contains("Enterprise");
    }

    public boolean isFreeLicense(String userName, String serialNumber) {
        return FREE_USER_NAME.equals(userName) && FREE_SERIAL_NUMBER.equals(serialNumber);
    }

    public static enum Status {
        Invalid,
        Trial,
        Timeout,
        Valid;

    }
}

