/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.UserAnnotationProcessingModule;
import com.pvsstudio.Version;
import com.pvsstudio.annotation.AnnotationService;
import com.pvsstudio.annotation.declaration.JavaAnnotationModule;
import com.pvsstudio.dataflow.DataFlowModule;
import com.pvsstudio.dataflow.annotation.DataFlowAnnotationSetter;
import com.pvsstudio.dataflow.annotation.OneTimeAnnotationSetter;
import com.pvsstudio.dataflow.java.AnnotationSetter;
import com.pvsstudio.dataflow.java.DataFlow;
import com.pvsstudio.rules.PvsStudioRule;
import com.pvsstudio.runner.AnalyzerProgress;
import com.pvsstudio.runner.AnalyzerRunner;
import com.pvsstudio.runner.AnalyzerThreadFactory;
import com.pvsstudio.runner.PvsStudioAnalyzer;
import com.pvsstudio.runner.StdOutProgress;
import com.pvsstudio.timeout.DefaultTimeoutCheckerFactory;
import com.pvsstudio.timeout.TimeoutCheckerFactory;
import com.pvsstudio.warnings.Warning;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import spoon.reflect.reference.CtTypeReference;

public class AnalyzerModule
extends AbstractModule {
    private final AnalyzerConfig config;

    public AnalyzerModule(AnalyzerConfig config) {
        this.config = config;
    }

    public void configure() {
        this.install((Module)new JavaAnnotationModule());
        this.install((Module)new UserAnnotationProcessingModule());
        this.install((Module)new DataFlowModule(this.config, Version.isDevelopment()));
        this.bind(AnalyzerRunner.class).in(Singleton.class);
        this.bind(AnalyzerProgress.class).toInstance((Object)new StdOutProgress());
        this.bind(AnalyzerConfig.class).toInstance((Object)this.config);
        this.bind(PvsStudioAnalyzer.class);
        this.bind(new TypeLiteral<Map<String, CtTypeReference<?>>>(){}).annotatedWith((Annotation)Names.named((String)"annotationCache")).toInstance(new ConcurrentHashMap());
        this.bind((TypeLiteral)new TypeLiteral<Set<Warning>>(){}).annotatedWith((Annotation)Names.named((String)"warnings")).toInstance(new HashSet());
        this.bind(AnalyzerThreadFactory.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    AnnotationSetter annotationSetter(DataFlow dataFlow, AnnotationService service) {
        return new OneTimeAnnotationSetter(new DataFlowAnnotationSetter(dataFlow, service));
    }

    @Provides
    @Singleton
    TimeoutCheckerFactory timeoutChecker(AnalyzerConfig config) {
        return new DefaultTimeoutCheckerFactory(Duration.ofMinutes(config.timeout.intValue()));
    }

    @Provides
    @Named(value="rules")
    private List<PvsStudioRule> provideRules() {
        ArrayList<PvsStudioRule> rules = new ArrayList<PvsStudioRule>();
        String packageName = PvsStudioRule.class.getPackage().getName();
        Reflections reflections = new Reflections(packageName, new Scanner[0]);
        Set ruleClasses = reflections.getSubTypesOf(PvsStudioRule.class);
        for (Class rule : ruleClasses) {
            if (Modifier.isAbstract(rule.getModifiers())) continue;
            try {
                rules.add((PvsStudioRule)((Object)rule.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new PvsStudioException("Failed to instantiate the rules", e);
            }
        }
        return rules;
    }
}

